<div class="col-12">
    <div class="card bg-white p-3">
        <form id="send-notif-form" action="{{ route('admin.notifications.send') }}" method="POST"
            enctype="multipart/form-data">
            @csrf
            <div class="form-group row mb-3">
                <div class="col-12 col-lg-6">
                    <label for="add-title" class="col-form-label required">
                        {{ __('admin/notifications.form.title') }}
                    </label>
                    <input type="text" name="title" class="form-control" id="add-title" value="{{ old('title') }}">
                </div>
            </div>
            <div class="form-group row mb-3">
                <div class="col-12 col-lg-6">
                    <label for="add-description" class="col-form-label required">
                        {{ __('admin/notifications.form.users') }}
                    </label>
                    <select name="users[]" class="form-control selectpicker" multiple data-live-search="true">
                        @foreach ($users as $user)
                            <option value="{{ $user->id }}">{{ $user->first_name . ' ' . $user->last_name }}
                            </option>
                        @endforeach
                    </select>
                </div>
            </div>
            <div class="form-group row mb-3">
                <div class="col-12 col-lg-6">
                    <label for="add-description" class="col-form-label required">
                        {{ __('admin/notifications.form.body') }}
                    </label>
                    <textarea name="body" class="form-control" rows="5">{{ old('body') }}</textarea>
                </div>
            </div>
            <div class="form-group row">
                <x-admin.form.save-button title="{{ __('admin/common.btn.save') }}" />
            </div>
        </form>
    </div>
    <script>
        $(document).ready(function() {

            $('#send-notif-form').on('submit', function(e) {

                e.preventDefault();

                function initFirebaseMessagingRegistration() {
                    messaging
                        .requestPermission()
                        .then(function() {
                            return messaging.getToken()
                        })
                        .then(function(token) {
                            console.log(token);

                            $.ajaxSetup({
                                headers: {
                                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                                }
                            });

                            let form = $('#send-notif-form');

                            let formData = new FormData(form[0]);

                            formData.append('token', token)

                            $.ajax({
                                url: '{{ route('admin.notifications.save_token') }}',
                                type: 'POST',
                                data: formData,
                                dataType: 'JSON',
                                success: function(response) {
                                    alert('Token saved successfully.');
                                },
                                error: function(err) {
                                    console.log('User Chat Token Error' + err);
                                },
                            });

                        }).catch(function(err) {
                            console.log('User Chat Token Error' + err);
                        });
                }
                messaging.onMessage(function(payload) {
                     const noteTitle = payload.notification.title;
                     const noteOptions = {
                         body: payload.notification.body,
                         icon: payload.notification.icon,
                     };
                     new Notification(noteTitle, noteOptions);
                 });
            });
        });
    </script>
</div>
